import { inspect } from "util";
export function getSuperclasses(obj) {
    const superclasses = [];
    let prototype = Object.getPrototypeOf(obj);
    while (prototype !== null) {
        superclasses.push(prototype.constructor.name);
        prototype = Object.getPrototypeOf(prototype);
    }
    return superclasses;
}
export function jsonifyError(error) {
    const wrappedError = {};
    wrappedError.name = error.name || "<no name available>";
    wrappedError.className = error.constructor.name || "<no class name available>";
    wrappedError.message = error.message || "<no message available>";
    wrappedError.superclasses = getSuperclasses(error);
    wrappedError.inspect = inspect(error);
    if (typeof error.stack === "string" && error.stack.length > 0) {
        wrappedError.stack = error.stack
            .split("\n")
            .map((x) => x.replace(/^\s+/, ""))
            .filter((x) => x);
    }
    else {
        wrappedError.stack = "<no stack trace available>";
    }
    return wrappedError;
}
export class AgentError extends Error {
    data;
    constructor(message, data = {}) {
        super(message);
        this.data = data;
    }
}
//# sourceMappingURL=utils.js.map